﻿#pragma once
#include <unordered_map>

namespace RTCam {

class Mesh;
class Material;
class Texture;
class Texture1D;

class ResourceManager
{
public:
	ResourceManager(void);
	~ResourceManager(void);

	void Initialize(_In_ ID3D11Device1* device);

	// TODO: Finish implementing
	// Add/retrieve the mesh with the given name
	void AddMesh(const shared_ptr<Mesh>& mesh);
	weak_ptr<Mesh> GetMesh(const string& name);

	// Add/retrieve the material with the given name
	void AddMaterial(const shared_ptr<Material>& material);
	weak_ptr<Material> GetMaterial(const string& name);
	// END TODO

	// Default meshes
	shared_ptr<Mesh> m_meshColorCube;
	shared_ptr<Mesh> m_meshCube;
	
	// Default materials
	shared_ptr<Material> m_matDefault;
	shared_ptr<Material> m_matEmissive;
	shared_ptr<Material> m_matMagenta;

	// Default textures
	shared_ptr<Texture> m_texBokeh;
	shared_ptr<Texture> m_texPositiveSA;
	shared_ptr<Texture> m_texZeroSA;
	shared_ptr<Texture> m_texNegativeSA;

	shared_ptr<Texture1D> m_texDefault1D;
	shared_ptr<Texture1D> m_texDefaultVignetting;

private:
	void CreateDefaultMeshes(_In_ ID3D11Device1* device);
	void CreateDefaultMaterials(_In_ ID3D11Device1* device);
	void CreateDefaultTextures(_In_ ID3D11Device1* device);

	// TODO: Hash strings and use that value instead.
	std::unordered_map<string, shared_ptr<Mesh>> m_meshDictionary;
	std::unordered_map<string, shared_ptr<Material>> m_materialDictionary;
};

} // end namespace